/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.IChatMessages;
import noppes.npcs.client.TextBlockClient;
import org.lwjgl.opengl.GL11;

public class RenderChatMessages
implements IChatMessages {
    private final int boxLength;
    private String lastMessage = "";
    private long lastMessageTime = 0L;
    private Map<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
    private final float scale;

    public RenderChatMessages() {
        this.boxLength = 46;
        this.scale = 0.5f;
    }

    @Override
    public void addMessage(String message, Entity entity) {
        if (!CustomNpcs.EnableChatBubbles) {
            return;
        }
        long time = System.currentTimeMillis();
        if (message.equals(this.lastMessage) && this.lastMessageTime + 5000L > time) {
            return;
        }
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>(this.messages);
        messages.put(time, new TextBlockClient(message, this.boxLength * 4, true, entity, Minecraft.func_71410_x().field_71439_g, entity));
        if (messages.size() > 3) {
            messages.remove(messages.keySet().iterator().next());
        }
        this.messages = messages;
        this.lastMessage = message;
        this.lastMessageTime = time;
    }

    private void drawRect(int left, int top, int right, int bottom, int color, double zLevel) {
        int j1;
        if (left < right) {
            j1 = left;
            left = right;
            right = j1;
        }
        if (top < bottom) {
            j1 = top;
            top = bottom;
            bottom = j1;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder tessellator = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179131_c((float)f2, (float)f3, (float)f4, (float)f);
        tessellator.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tessellator.func_181662_b((double)left, (double)bottom, zLevel).func_181675_d();
        tessellator.func_181662_b((double)right, (double)bottom, zLevel).func_181675_d();
        tessellator.func_181662_b((double)right, (double)top, zLevel).func_181675_d();
        tessellator.func_181662_b((double)left, (double)top, zLevel).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    private Map<Long, TextBlockClient> getMessages() {
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
        long time = System.currentTimeMillis();
        for (Map.Entry<Long, TextBlockClient> entry : this.messages.entrySet()) {
            if (time > entry.getKey() + 10000L) continue;
            messages.put(entry.getKey(), entry.getValue());
        }
        this.messages = messages;
        return this.messages;
    }

    private void render(double x, double y, double z, float textscale, boolean depth, boolean isPlayer) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float var13 = 1.6f;
        float var14 = 0.016666668f * var13;
        int size = 0;
        ArrayList<Long> del = new ArrayList<Long>();
        for (Long time : this.messages.keySet()) {
            TextBlockClient block = this.messages.get(time);
            if (block.entity != null && !block.entity.func_70089_S()) {
                del.add(time);
                if (!this.lastMessage.equals(block.text)) continue;
                this.lastMessage = "";
                this.lastMessageTime = 0L;
                continue;
            }
            size += block.lines.size();
        }
        for (Long key : del) {
            this.messages.remove(key);
        }
        if (size == 0) {
            return;
        }
        GlStateManager.func_179094_E();
        Minecraft mc = Minecraft.func_71410_x();
        int textYSize = (int)((float)(size * font.field_78288_b) * this.scale);
        GlStateManager.func_179137_b((double)(x + 0.0), (double)(y + (double)((float)textYSize * textscale * var14)), (double)z);
        GlStateManager.func_179152_a((float)textscale, (float)textscale, (float)textscale);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)mc.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-var14), (float)(-var14), (float)var14);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        if (depth) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        Color[] cs = isPlayer ? CustomNpcs.ChatPlayerColors : CustomNpcs.ChatNpcColors;
        int color = cs[0].getRGB() + (depth ? -16777216 : 0x55000000);
        int border = cs[1].getRGB() + (depth ? -16777216 : 0x55000000);
        int place = cs[2].getRGB() + (depth ? -1157627904 : 0x44000000);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        GlStateManager.func_179089_o();
        int w = 0;
        for (TextBlockClient block2 : this.messages.values()) {
            for (ITextComponent chat : block2.lines) {
                int g = font.func_78256_a(chat.func_150254_d()) / 3;
                if (g <= w) continue;
                w = g;
            }
        }
        if (w > this.boxLength) {
            w = this.boxLength;
        }
        this.drawRect(-w - 2, -2, w + 2, textYSize + 1, place, 0.11);
        this.drawRect(-w - 1, -3, w + 1, -2, border, 0.1);
        this.drawRect(-w - 1, textYSize + 2, -1, textYSize + 1, border, 0.1);
        this.drawRect(3, textYSize + 2, w + 1, textYSize + 1, border, 0.1);
        this.drawRect(-w - 3, -1, -w - 2, textYSize, border, 0.1);
        this.drawRect(w + 3, -1, w + 2, textYSize, border, 0.1);
        this.drawRect(-w - 2, -2, -w - 1, -1, border, 0.1);
        this.drawRect(w + 2, -2, w + 1, -1, border, 0.1);
        this.drawRect(-w - 2, textYSize + 1, -w - 1, textYSize, border, 0.1);
        this.drawRect(w + 2, textYSize + 1, w + 1, textYSize, border, 0.1);
        this.drawRect(0, textYSize + 1, 3, textYSize + 4, place, 0.11);
        this.drawRect(-1, textYSize + 4, 1, textYSize + 5, place, 0.11);
        this.drawRect(-1, textYSize + 1, 0, textYSize + 4, border, 0.1);
        this.drawRect(3, textYSize + 1, 4, textYSize + 3, border, 0.1);
        this.drawRect(2, textYSize + 3, 3, textYSize + 4, border, 0.1);
        this.drawRect(1, textYSize + 4, 2, textYSize + 5, border, 0.1);
        this.drawRect(-2, textYSize + 4, -1, textYSize + 5, border, 0.1);
        this.drawRect(-2, textYSize + 5, 1, textYSize + 6, border, 0.1);
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        int index = 0;
        for (TextBlockClient block2 : this.messages.values()) {
            for (ITextComponent chat : block2.lines) {
                String message = chat.func_150254_d();
                font.func_78276_b(message, -font.func_78256_a(message) / 2, index * font.field_78288_b, color);
                ++index;
            }
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderMessages(double x, double y, double z, float textscale, boolean inRange) {
        Map<Long, TextBlockClient> messages = this.getMessages();
        if (messages.isEmpty()) {
            return;
        }
        if (inRange) {
            this.render(x, y, z, textscale, false, false);
        }
        this.render(x, y, z, textscale, true, false);
    }

    public void renderPlayerMessages(double x, double y, double z, float textscale, boolean inRange) {
        Map<Long, TextBlockClient> messages = this.getMessages();
        if (messages.isEmpty()) {
            return;
        }
        if (inRange) {
            this.render(x, y, z, textscale, false, true);
        }
        this.render(x, y, z, textscale, true, true);
    }
}

